/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * The type of the evaluation
 */
export type EvalTypeID = string;
/**
 * Random seed
 */
export type RandomSeed = number;
/**
 * List of dataset names. We want to unlearn wmdp-bio while retaining knowledge in other datasets
 */
export type DatasetNames = string[];
/**
 * Intervention method. We only support 'clamp_feature_activation' for now
 */
export type InterventionMethod = string;
/**
 * We ignore features that activate more than this threshold on the retain dataset
 */
export type RetainThresholds = number[];
/**
 * Each N is the number of features we select and clamp to a negative value
 */
export type NFeaturesList = number[];
/**
 * A list of negative values. We iterate over this list, clamping the selected features to each value
 */
export type Multipliers = number[];
/**
 * Dataset size we use when calculating feature sparsity
 */
export type DatasetSize = number;
/**
 * Sequence length when calculating feature sparsity
 */
export type SequenceLength = number;
/**
 * Number of batches to use when calculating the loss added by an intervention (currently not supported).
 */
export type NBatchLossAdded = number;
/**
 * Controls the type of `question_ids` we load. We support 'correct', `correct-iff-question`, and `correct-no-tricks
 */
export type TargetMetric = string;
/**
 * If true, we save the metrics for each set of intervention hyperparameters. This is required to be true currently, as the unlearning score is calculated over all results.
 */
export type SaveMetricsFlag = boolean;
/**
 * Model name. Must be set with a command line argument. We recommend instruct tuned models >= 2B parameters.
 */
export type ModelName = string;
/**
 * LLM batch size. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMBatchSize = number;
/**
 * LLM data type. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMDataType = string;
/**
 * A unique UUID identifying this specific eval run
 */
export type ID = string;
/**
 * The datetime of the evaluation in epoch milliseconds
 */
export type DateTimeEpochMs = number;
/**
 * Unlearning score, using methodology from APPLYING SPARSE AUTOENCODERS TO UNLEARN KNOWLEDGE IN LANGUAGE MODELS
 */
export type UnlearningScore = number;
/**
 * Optional. The details of the evaluation. A list of objects that stores nested or more detailed data, such as details about the absorption of each letter.
 */
export type ResultDetails = BaseResultDetail[];
/**
 * The commit hash of the SAE Bench that ran the evaluation.
 */
export type SAEBenchCommitHash = string;
/**
 * The ID of the SAE in SAE Lens.
 */
export type SAELensID = string | null;
/**
 * The release ID of the SAE in SAE Lens.
 */
export type SAELensReleaseID = string | null;
/**
 * The version of SAE Lens that ran the evaluation.
 */
export type SAELensVersion = string | null;
/**
 * The configuration of the SAE (custom or from SAE Lens) that ran the evaluation. This should match the SAE Lens config schema.
 */
export type SAEConfigDict = {
  [k: string]: unknown;
} | null;

/**
 * An evaluation of the ability of SAEs to unlearn biology knowledge from LLMs, using methodology from `Applying Sparse Autoencoders to Unlearn Knowledge in Language Models`
 */
export interface Unlearning {
  eval_type_id?: EvalTypeID;
  eval_config: EvalConfigType;
  eval_id: ID;
  datetime_epoch_millis: DateTimeEpochMs;
  eval_result_metrics: ResultMetricsCategorized;
  eval_result_details?: ResultDetails;
  sae_bench_commit_hash: SAEBenchCommitHash;
  sae_lens_id: SAELensID;
  sae_lens_release_id: SAELensReleaseID;
  sae_lens_version: SAELensVersion;
  sae_cfg_dict: SAEConfigDict;
  eval_result_unstructured?: unknown;
  [k: string]: unknown;
}
/**
 * The configuration of the evaluation.
 */
export interface EvalConfigType {
  random_seed?: RandomSeed;
  dataset_names?: DatasetNames;
  intervention_method?: InterventionMethod;
  retain_thresholds?: RetainThresholds;
  n_features_list?: NFeaturesList;
  multipliers?: Multipliers;
  dataset_size?: DatasetSize;
  seq_len?: SequenceLength;
  n_batch_loss_added?: NBatchLossAdded;
  target_metric?: TargetMetric;
  save_metrics?: SaveMetricsFlag;
  model_name?: ModelName;
  llm_batch_size?: LLMBatchSize;
  llm_dtype?: LLMDataType;
  [k: string]: unknown;
}
/**
 * The metrics of the evaluation, organized by category. Define your own categories and the metrics that go inside them.
 */
export interface ResultMetricsCategorized {
  unlearning: Unlearning1;
  [k: string]: unknown;
}
/**
 * Metrics related to unlearning
 */
export interface Unlearning1 {
  unlearning_score: UnlearningScore;
  [k: string]: unknown;
}
export interface BaseResultDetail {
  [k: string]: unknown;
}
